/*:
 * @target MZ
 * @plugindesc v1.2 Localize HS_FastMode option labels (Fast/Auto/Protect) with safe title fallback & first-open fix
 * @author HS
 *
 * @help
 * HS_FastMode（高速モード／自動送り／重要シーンを保護）のオプション表示名を多言語化。
 * タイトル時は言語別フォールバック、ゲーム中は任意のラベル用変数（文字列）を優先。
 * 初回起動でオプションを開いた直後にも確実に反映されるよう、Scene_Options.start で
 * リラベル＆次フレーム再ラベルを追加（取りこぼし防止）。
 *
 * 【順序】HS_LangSimple →（互換/ブリッジ）→ HS_FastMode → HS_FastMode_CustomFadeCompat → 本プラグイン
 *
 * @param fastLabelVarId
 * @text 高速ラベル用 変数ID
 * @type variable
 * @default 0
 * @param autoLabelVarId
 * @text 自動送りラベル用 変数ID
 * @type variable
 * @default 0
 * @param protectLabelVarId
 * @text 保護ラベル用 変数ID
 * @type variable
 * @default 0
 *
 * @param fastFb0 @text 高速(0:日本語) @default 高速モード
 * @param fastFb1 @text 高速(1:English) @default Fast Mode
 * @param fastFb2 @text 高速(2:简体中文) @default 高速模式
 * @param fastFb3 @text 高速(3:한국어) @default 고속 모드
 *
 * @param autoFb0 @text 自動(0:日本語) @default 自動送り
 * @param autoFb1 @text 自動(1:English) @default Auto-Advance
 * @param autoFb2 @text 自動(2:简体中文) @default 自动播放
 * @param autoFb3 @text 自動(3:한국어) @default 자동 진행
 *
 * @param protectFb0 @text 保護(0:日本語) @default 重要シーンを保護
 * @param protectFb1 @text 保護(1:English) @default Protect Key Scenes
 * @param protectFb2 @text 保護(2:简体中文) @default 重要场景保护
 * @param protectFb3 @text 保護(3:한국어) @default 중요 씬 보호
 */
(() => {
  "use strict";
  const PN = "HS_FastOptionLocalize";
  const P  = PluginManager.parameters(PN);

  const fastVarId    = Number(P.fastLabelVarId    || 0);
  const autoVarId    = Number(P.autoLabelVarId    || 0);
  const protectVarId = Number(P.protectLabelVarId || 0);

  const fastFB    = [P.fastFb0||"", P.fastFb1||"", P.fastFb2||"", P.fastFb3||""];
  const autoFB    = [P.autoFb0||"", P.autoFb1||"", P.autoFb2||"", P.autoFb3||""];
  const protectFB = [P.protectFb0||"", P.protectFb1||"", P.protectFb2||"", P.protectFb3||""];

  // HS_LangSimple が保持する現在の言語 index（0:JP,1:EN,2:ZH,3:KO...）
  function langIndex(){
    return Number(ConfigManager && ConfigManager.hs_langIndex != null
      ? ConfigManager.hs_langIndex : 0);
  }

  function isNonEmptyString(v){ return typeof v === "string" && v.trim() !== ""; }

  function pickVarText(varId){
    if (varId>0 && window.$gameVariables && $gameVariables._data){
      const v = $gameVariables.value(varId);
      if (isNonEmptyString(v)) return String(v);
    }
    return null;
  }

  function fastLabel(){    return pickVarText(fastVarId)    ?? (fastFB[langIndex()]    || fastFB[0] || "Fast Mode"); }
  function autoLabel(){    return pickVarText(autoVarId)    ?? (autoFB[langIndex()]    || autoFB[0] || "Auto-Advance"); }
  function protectLabel(){ return pickVarText(protectVarId) ?? (protectFB[langIndex()] || protectFB[0] || "Protect Key Scenes"); }

  // Optionsリスト内の "fastMode" / "hsAuto" / "hsProtect" を差し替え
  function relabel(win){
    if (!win || !win._list) return;
    for (let i=0;i<win._list.length;i++){
      const it = win._list[i];
      if (!it) continue;
      if (it.symbol === "fastMode")  it.name = fastLabel();
      if (it.symbol === "hsAuto")    it.name = autoLabel();
      if (it.symbol === "hsProtect") it.name = protectLabel();
    }
  }

  // 追加直後（項目が出そろった直後）に差し替え
  const _addGeneral = Window_Options.prototype.addGeneralOptions;
  Window_Options.prototype.addGeneralOptions = function(){
    _addGeneral.apply(this, arguments);
    try{ relabel(this); }catch(_){}
  };

  // 再描画ごとに差し替え（言語変更後の反映）
  const _refresh = Window_Options.prototype.refresh;
  Window_Options.prototype.refresh = function(){
    try{ relabel(this); }catch(_){}
    _refresh.call(this);
  };

  // ★初回起動や互換プラグイン追加の直後でも取りこぼさない保険
  const _optStart = Scene_Options.prototype.start;
  Scene_Options.prototype.start = function(){
    _optStart.call(this);
    // 直後に一度
    if (this._optionsWindow){
      try{ relabel(this._optionsWindow); this._optionsWindow.refresh(); }catch(_){}
      // 次フレームでもう一度（他プラグインが後から差し込んだ項目に追従）
      setTimeout(()=>{
        try{ relabel(this._optionsWindow); this._optionsWindow.refresh(); }catch(_){}
      }, 0);
    }
  };
})();
